<?php

use App\Http\Controllers\Api\CustomersController;
use App\Http\Controllers\Api\GiftbillController;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\MonnifyController;
use App\Http\Controllers\Api\NibbsController;
use App\Http\Controllers\Api\NibbspayController;
use App\Http\Controllers\Api\RegisterController;
use App\Http\Controllers\Api\VtpassController;
use App\Http\Controllers\Api\TransactionController;
use App\Http\Controllers\Api\WhatsappController;
use App\Http\Controllers\Api\WirelessController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


global $payoption;
$payoption = \App\Models\Setting::first();


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('/customers')->group(function () {
    Route::middleware(['log.route'])->group(function () {
        Route::post('/login', [LoginController::class, 'login']);
        Route::post('/logout', [LoginController::class, 'logout_customer'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::post('/register', [RegisterController::class, 'register']);
        Route::post('/existregister', [RegisterController::class, 'existingAccount']);
        Route::post('/bvn', [CustomersController::class, 'verifyBvn']);

        Route::post('/confirm-otp', [CustomersController::class, 'confirm_otp']);
        Route::post('/verify-otp', [CustomersController::class, 'verify_otp']);
        Route::post('/resend-otp', [CustomersController::class, 'resend_otp']);
        Route::post('/forgot-password', [CustomersController::class, 'forgetpassword']);
        Route::post('/reset-password', [CustomersController::class, 'reset_password']);

        Route::post('/phone-otp', [RegisterController::class, 'sendPhoneOtp']);
        Route::post('phone-verify', [RegisterController::class, 'verifyPhoneOtp']);
        Route::post('phone/resend-otp', [RegisterController::class, 'resendPhoneOtp']);

        Route::post('/change-password', [CustomersController::class, 'change_password'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::post('/change-pin', [CustomersController::class, 'reset_pin'])->middleware(['auth:sanctum', 'abilities:customer']);
        //resetPin
        Route::post('/upload-file', [CustomersController::class, 'uploadFile'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::get('/get-details', [CustomersController::class, 'get_customers_details'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::post('/update-profile', [CustomersController::class, 'update_profile'])->middleware(['auth:sanctum', 'abilities:customer']);

        //get customer balance
        Route::get('/get-balance', [CustomersController::class, 'getBalance'])->middleware(['auth:sanctum', 'abilities:customer']);

        //get beneficiary
        Route::get('/get-beneficiary', [CustomersController::class, 'getbeneficiary'])->middleware(['auth:sanctum', 'abilities:customer']);

        //for web
        Route::get('/get-transactions', [CustomersController::class, 'getTransactions'])->middleware(['auth:sanctum', 'abilities:customer']);

        //link device
        Route::post('/send/linkdevice-otp', [CustomersController::class, 'sendLinkDeviceOtp']);
        Route::post('/resend/linkdevice-otp', [CustomersController::class, 'resendLinkDeviceOtp']);
        Route::post('/verify/linkdevice-otp', [CustomersController::class, 'verifyLinkDeviceOTP']);
    });
});

Route::post('/bvn', [RegisterController::class, 'bvn'])->middleware(['log.route']);


Route::post('/bvn/verification', [TransactionController::class, 'bvn_verify'])->middleware(['log.route']);

Route::post('/transactions/webhook/notification-payload', [TransactionController::class, 'save_notification_payload']);

Route::prefix('/transactions')->group(function () {
    Route::middleware(['log.route'])->group(function () {
        global $payoption;

        
        Route::post('/verify-smartcard', [VtpassController::class, 'verify_smartcard_number']);
        Route::get('/get-subcriptions', [VtpassController::class, 'get_subcriptions']);
        Route::post('/pay-cabletv-subcription', [VtpassController::class, 'pay_cable_tv'])->middleware(['auth:sanctum', 'abilities:customer']);

        Route::post('/buy-airtime', [VtpassController::class, 'buy_airtime'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::get('/get-databundles/{networktype}', [VtpassController::class, 'getdatabundles']);
        Route::post('/buy-data-bundle', [VtpassController::class, 'buy_data_bundle'])->middleware(['auth:sanctum', 'abilities:customer']);

        Route::post('/verify-meter', [VtpassController::class, 'verify_meter_number']);
        Route::post('/pay-electricty', [VtpassController::class, 'pay_electricty'])->middleware(['auth:sanctum', 'abilities:customer']);

        Route::get('/betting-providers', [GiftbillController::class, 'get_betting_companies']);
        Route::post('/verify-betting-account', [GiftbillController::class, 'verify_betting_account']);
        Route::post('/top-betting-account', [GiftbillController::class, 'topup_betting'])->middleware(['auth:sanctum', 'abilities:customer']);

        Route::get('/get-transaction-statement', [TransactionController::class, 'get_transactionStatement'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::get('/get-transaction-history', [TransactionController::class, 'get_transactionHistory'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::get('/single-transaction/{ref}', [TransactionController::class, 'single_transaction'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::get(
            '/get-transaction-websocket',
            [TransactionController::class, 'get_transactionWebsock']
        )->middleware(['auth:sanctum', 'abilities:customer']);

        Route::get('/get-transaction-statement', [TransactionController::class, 'send_transactionStatement'])->middleware(['auth:sanctum', 'abilities:customer']);

        //wallet to wallet transfer
        Route::post('/verify-wallet-account', [TransactionController::class, 'verifyWalletAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::post('/wallet/initiate-transaction', [TransactionController::class, 'initiateTransaction'])->middleware(['auth:sanctum', 'abilities:customer']);
        Route::post('/wallet-transfer', [TransactionController::class, 'transferToWalletAccount'])->middleware(['auth:sanctum', 'abilities:customer']);

        Route::get('/get-banks', [TransactionController::class, 'getAllBanks'])->middleware(['auth:sanctum', 'abilities:customer']);

        if ($payoption->getsettingskey('payoption') == "1") {

            Route::post('/verify-bank-account', [TransactionController::class, 'verifyBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/initiate-transaction', [TransactionController::class, 'initiateTransaction'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/bank-transfer', [TransactionController::class, 'transferToBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
        } elseif ($payoption->getsettingskey('payoption') == "2") { //monnify transfer

            Route::get('/get-banks', [MonnifyController::class, 'getBanks']);
            Route::post('/verify-bank-account', [MonnifyController::class, 'VeriyBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/initiate-transaction', [MonnifyController::class, 'initiateTransaction'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/bank-transfer', [MonnifyController::class, 'transferToBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
        } elseif ($payoption->getsettingskey('payoption') == "3") { //nibbspay
            Route::post('/verify-bank-account', [NibbspayController::class, 'VeriyBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/initiate-transaction', [NibbspayController::class, 'initiateTransaction'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/bank-transfer', [NibbspayController::class, 'transferToBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
        } elseif ($payoption->getsettingskey('payoption') == "4") {
            Route::post('/verify-bank-account', [WirelessController::class, 'VeriyBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/initiate-transaction', [WirelessController::class, 'initiateTransaction'])->middleware(['auth:sanctum', 'abilities:customer']);
            Route::post('/bank-transfer', [WirelessController::class, 'transferToBankAccount'])->middleware(['auth:sanctum', 'abilities:customer']);
        }

        Route::get('/transaction_receipt/{ref}', [TransactionController::class, 'transaction_recipt'])->middleware(['auth:sanctum', 'abilities:customer']);
    });
});

//whatsapp
Route::post('/whatsapp', [WhatsappController::class, 'whatsapp_index']);

Route::prefix('/accounts')->group(function () {

    Route::middleware("checkip")->get('/lookup/{account_number}', [NibbsController::class, 'lookupAccount'])->name('look-account');

    Route::middleware("checkip")->post('/block', [NibbsController::class, 'blockUserAccount'])->name('block-user-account');
    Route::middleware("checkip")->post('/unblock', [NibbsController::class, 'unblockUserAccount'])->name('unblock-user-account');
    Route::middleware("checkip")->post('/credit-user', [NibbsController::class, 'creditUser'])->name('credit-customer');
    Route::middleware("checkip")->post('/debit-user', [NibbsController::class, 'debitUser'])->name('debit-user');
    Route::middleware("checkip")->post('/balance', [NibbsController::class, 'getAccountBalance'])->name('account-balance');
    Route::middleware("checkip")->post('/amount/block', [NibbsController::class, 'lienAccount'])->name('lien-account');
    Route::middleware("checkip")->post('/amount/unblock', [NibbsController::class, 'unlienAccount'])->name('unlien-account');
    Route::middleware("checkip")->post('/advice', [NibbsController::class, 'accountMandate'])->name('account-manadate');
    Route::middleware("checkip")->post('/advice/debit-user', [NibbsController::class, 'directDebitMandate'])->name('direct-debit-mandate');
    Route::middleware("checkip")->post('/fi', [NibbsController::class, 'addNewBanks'])->name('add-new-banks');
    Route::middleware("checkip")->post('/advice/credit-user', [NibbsController::class, 'creditUser'])->name('credit-user-advice');
    Route::middleware("checkip")->post('/funds-transfer-advice/credit-user', [NibbsController::class, 'reverseFundsTransferCredit'])->name('funds-transfer-reversal-credit-user');
    Route::middleware("checkip")->post('/funds-transfer-advice/debit-user', [NibbsController::class, 'reverseFundsTransferDebit'])->name('funds-transfer-reversal-debit-user');
});
